<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
* UserRole Model
*/
class Role_Permissions_Model extends CI_Model
{
	public $table = 'page';
	
	public function __construct()
	{
		parent::__construct();
		
	}

	public function insert(){

		$data = array(
			'page_title' => $this->input->post('page_title'),
			'page_label' => $this->input->post('page_label'),
			'page_url' => $this->input->post('page_url'),
			'parent_page' => $this->input->post('parent_page'),
			'page_level' => $this->_setPageLevel(),
			'is_page_section' => ($this->input->post('is_page_section')==null)?'0':$this->input->post('is_page_section'),
			'add_to_menu' => ($this->input->post('add_to_menu')==null)?'0':$this->input->post('add_to_menu'),
			'exchange_section_with' => $this->input->post('exchange_section_with'),
			'allowed_roles'=>'1'
			);

		return $this->db->insert($this->table,$data);
	}

	public function update(){
		$data = array(
			'page_title' => $this->input->post('page_title'),
			'page_label' => $this->input->post('page_label'),
			'page_url' => $this->input->post('page_url'),
			'parent_page' => $this->input->post('parent_page'),
			'page_level' => $this->_setPageLevel(),
			'is_page_section' => ($this->input->post('is_page_section')==null)?'0':$this->input->post('is_page_section'),
			'add_to_menu' => ($this->input->post('add_to_menu')==null)?'0':$this->input->post('add_to_menu'),
			'exchange_section_with' => $this->input->post('exchange_section_with'),
			);
		$this->db->where('page_ID', $this->input->post('page_ID'));
		return $this->db->update($this->table,$data);
	}

	public function get( $page_ID = null){
		if($page_ID==null){
			$query = $this->db->get($this->table);
			return $this->parsePermissions($query->result());
		}
		$query = $this->db->get_where($this->table,array('page_ID' => $page_ID));
		return $query->row();
	}

	public function delete($page_ID ){
		return $this->db->delete($this->table, array('page_ID' => $page_ID ));
	}

	public function update_permissions(){
		$permissions = ($this->input->post('perm')!==NULL)? $this->input->post('perm'):array();

		$this->db->trans_start();
		foreach($permissions as $perm_ID=>$allowed_roles) {

			$data = array(
				'allowed_roles'=> implode(',',$allowed_roles)
				);

			$this->db->where('page_ID', $perm_ID);
			$this->db->update($this->table,$data);
		}
		$this->db->trans_complete();
		
		return (!empty($permissions))? $this->db->trans_status():FALSE;
	}


	public function getParentPages(){
		$query = $this->db->get($this->table);
		$parent_pages = array();
		foreach($this->parsePermissions($query->result()) as $page){

			while($page->page_level > 0){
				$page->page_title = '----'.$page->page_title;
				$page->page_level --;
			}
			
			$parent_pages[$page->page_ID] = $page->page_title;
		}
		return $parent_pages;
	}

	protected function _setPageLevel(){
		$parent_page = ($this->input->post('parent_page')!=='')? $this->input->post('parent_page'):null;
		$page_level=0;
		if($parent_page!==null){
			$page_level =1;
			if($this->hasParent($parent_page)){
				$page_level =2;
			}
		}
		return $page_level;
	}

	protected function hasParent($page){
		$query = $this->db->get_where($this->table,array('page_ID' => $page));
		return $query->row()->parent_page;
	}

	protected function parsePermissions($pages){
		$parsedPages = array();

		foreach($pages as $page){
			if($page->page_level=='0'){
				array_push($parsedPages,$page);
				foreach($pages as $subPage){
					if($subPage->page_level=='1' && $subPage->parent_page==$page->page_ID){
						array_push($parsedPages,$subPage);
						foreach($pages as $pageSection){
							if($pageSection->page_level=='2' && $pageSection->parent_page==$subPage->page_ID){
								array_push($parsedPages,$pageSection);
							}
						}
					}
				}
			}
		}

		return $parsedPages;
	}
}